<?PHP
/* ====================
[BEGIN_SED_EXTPLUGIN]
Code=contactus
Part=main
File=contactus
Hooks=standalone
Tags=
Order=10
[END_SED_EXTPLUGIN]
==================== */
// *********************************************
// *    Plugin:  "AN Contact Us"               *
// *      Main File                            *
// *    Alex & Natty studio                    *
// *        http://portal30.ru                 *
// *                                           *
// *            © Alex & Natty Studio  2010    *
// *********************************************
if (!defined('SED_CODE') || !defined('SED_PLUG')) { sed_diefatal('Wrong URL.'); }

require_once(sed_langfile('contactus'));

$a = sed_import('a','P','ALP');
$recipient = sed_import('recipient','P','INT');
$subject = sed_import('subject','P','TXT');
$message = sed_import('cus_message','P','TXT');
$name = sed_import('cus_name','P','TXT');
$email = sed_import('cus_email','P','TXT');
$rverify  = sed_import('rverify','P','TXT');

if (!empty($cfg['plugin']['contactus']['contacts']) && $cfg['plugin']['contactus']['contacts'] != ''){
	$t->assign(array(	
		"CONTACTUS_CONTACTS" => $cfg['plugin']['contactus']['contacts'],
	));
	$t->parse("MAIN.CONTACTS");
}

if (!empty($cfg['plugin']['contactus']['proezd']) && $cfg['plugin']['contactus']['proezd'] != ''){
	$t->assign(array(	
		"CONTACTUS_JOURNEY" => $cfg['plugin']['contactus']['proezd'],
	));
	$t->parse("MAIN.JOURNEY");	
}

if (!empty($cfg['plugin']['contactus']['note']) && $cfg['plugin']['contactus']['note'] != ''){
	$t->assign(array(	
		"CONTACTUS_NOTES" => $cfg['plugin']['contactus']['note'],
	));
	$t->parse("MAIN.NOTES");	
}

if ($a=="send") {
	if (empty($message) || empty($name) || empty($email)){
		$error_string = $L['plu_empty']."<br />\n"; 
	}
	
	// Получатель сообщения
	if ($cfg['plugin']['contactus']['email'] != ''){
		$cfgrecipients = explode(";", $cfg['plugin']['contactus']['email']);
		if (count($cfgrecipients) > 1 && !empty($cfgrecipients[1])){
			if (!is_numeric($recipient)){
				$error_string = $L['plu_empty']."<br />\n"; 
			}else{
				$rectr = trim($cfgrecipients[$recipient]);
			}
		}else{
			$rectr = $cfgrecipients[0];
		}
	}else{
		$rectr = trim($cfg['adminemail']);
	}
	
	// Тема сообщения
	if($cfg['plugin']['contactus']['subjects'] != ''){
		$cfgsubjects = explode(";", $cfg['plugin']['contactus']['subjects']);
		if (count($cfgsubjects) > 1 && !empty($cfgsubjects[1])){
			if (!is_numeric($subject)){
				$error_string = $L['plu_empty']."<br />\n"; 
			}else{
				$subrt = trim($cfgsubjects[$subject])." - ". $L['plu_from'];
			}
		}else{
			$subrt = $cfgsubjects[0]." - ". $L['plu_from'];
		}
	}else{
		$subject = htmlspecialchars($subject);
		$subject = ($subject != '') ? $subject : $L['plu_nosubject'];
		$subrt = trim($subject)." - ". $L['plu_from'];
	}
	
	
	
	if (mb_strlen($email)<4 || !preg_match('#^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]{2,})+$#i', $email)){
		$error_string .= $L['plu_wrongmail']."<br />\n"; 
	}
	
	if ($cfg['plugin']['contactus']['canBaned'] == 'No' && $usr['id'] == 0){
		// Проверяем бан-лист e-mail'ов
		$sql = sed_sql_query("SELECT banlist_reason, banlist_email FROM $db_banlist WHERE banlist_email!=''");
		while ($row = sed_sql_fetcharray($sql)){
			if (mb_strpos($row['banlist_email'], $email) !== false) { $bannedreason = $row['banlist_reason']; }
		}
		if (!empty($bannedreason)){
			$error_string .= $L['aut_emailbanned'].$bannedreason;
		}
	}
	if ($usr['id'] == 0 && $cfg['plugin']['contactus']['useCaptcha'] == 'Yes'){	
		$error_string .= sed_captcha_validate($rverify) ? '' : $L['captcha_error'].'<br />';
	}
	if (empty($error_string)){
		
		if ($usr['id'] > 0){
			$usr_url = sed_url('users','m=details&id='.$usr['id'].'&u='.$usr["name"], '', TRUE);
			if(mb_strpos($usr_url, $cfg['mainurl']) === false) $usr_url = $cfg['mainurl']."/".$usr_url;
			$sender = $name." (".$usr_url." )";
		}else{
			$sender = $name;
		}
		
		$headers = ("From: \"".$name."\" <".$email.">\n");
		$body = str_replace("{site}", $cfg["maintitle"]." - ".$cfg['mainurl'], $L['plu_message_body'] );
		$body = str_replace("{from}", $sender." <".$email.">", $body );
		$body = str_replace("{message}", $message, $body );
	
		sed_mail($rectr, $subrt, $body, $headers);
		
		$t->assign(array(	
			"CONTACTUS_MSG_BODY" => $L['plu_ok'],
		));
		$t->parse("MAIN.CONTACTUS_MSG");
		
		unset($recipient, $subject, $message, $name, $email);
	}else{
		$t->assign(array(	
			"CONTACTUS_ERROR_BODY" => $error_string,
		));
		$t->parse("MAIN.CONTACTUS_ERROR");
	}

}

//Список получателей в массив и selectbox
if ($cfg['plugin']['contactus']['email'] != ''){
	$cfgrecipients = explode(";", $cfg['plugin']['contactus']['email']);
	if (count($cfgrecipients) > 1 && !empty($cfgrecipients[1])){
		$recip = "<select name=\"recipient\">\n";
		$iii=0;
		foreach($cfgrecipients as $x) {
			if (!empty($x)) {
				$recipients[$iii] = trim($x);
				$whatdel = strrchr($recipients[$iii], "<");
				$recipients[$iii] = str_replace($whatdel, "", $recipients[$iii]); 
				$recipients[$iii] = trim($recipients[$iii]);
				if ($iii==$recipient || (empty($recipient) && $iii==0)) {
					$recip .= "<option value=\"".$iii."\" selected=\"selected\">".$recipients[$iii]."</option>\n";
				} else {
					$recip .= "<option value=\"".$iii."\">".$recipients[$iii]."</option>\n";
				}
				$iii++;
			}
		}
		$recip .= "</select>\n";
	}else{
		$recip = '';
	}
}else{
	$recip = '';
}

//Темы сообщений в массив и selectbox
if($cfg['plugin']['contactus']['subjects'] != ''){
	$cfgsubjects = explode(";", $cfg['plugin']['contactus']['subjects']);
	if (count($cfgsubjects) > 1 && !empty($cfgsubjects[1])){
		$cfgsubj = "<select name=\"subject\">\n";
		$iii=0;
		foreach($cfgsubjects as $x) {
			if (!empty($x)) {
				$subjects[$iii] = trim($x);
				if ($iii==$subject || (empty($subject) && $iii==0)) {
					$cfgsubj .= "<option value=\"".$iii."\" selected=\"selected\">".$subjects[$iii]."</option>\n";
				} else {
					$cfgsubj .= "<option value=\"".$iii."\">".$subjects[$iii]."</option>\n";
				}
				$iii++;
			}
		}
		$cfgsubj .= "</select>\n";
	}else{
		$cfgsubj = '';
	}
}else{
	$cfgsubj = "<input type=\"text\" maxlength=\"100\" size=\"24\" value=\"".$subject."\" name=\"subject\" id=\"subject\" class=\"text\" />";
}

$email = (empty($email)) ? $usr["profile"]["user_email"] : $email;

if ($usr['id'] < 1 && $cfg['plugin']['contactus']['useCaptcha'] == 'Yes'){
	$t->assign(array(	
		"CONTACTUS_VERIFYIMG" => sed_captcha_generate(),
    	"CONTACTUS_VERIFYINPUT" => "<input name=\"rverify\" type=\"text\" id=\"rverify\" size=\"10\" maxlength=\"6\" class=\"text\" />",
	));
	$t->parse("MAIN.CAPTCHA");
}
if ($usr['id'] < 1){
	$senderName = (empty($name)) ? '' : htmlspecialchars($name);
	$senderName = "<input type=\"text\" maxlength=\"100\" size=\"24\" value=\"".$senderName."\" name=\"cus_name\" id=\"cus_name\" class=\"text\" />";
}else{
	$senderName = "<strong>".$usr["name"]."</strong><input type=\"hidden\" name=\"cus_name\" id=\"cus_name\" value=\"".$usr["name"]."\" />";
}

$t->assign(array(	
	"PLUGIN_TITLE" => $L["plu_title"],
	"CONTACTUS_FORM_ACTION" => sed_url('plug', 'e=contactus'),
	"CONTACTUS_RECIPIENT" => $recip,
	"CONTACTUS_SUBJECT" => $cfgsubj,
	"CONTACTUS_SENDERNAME" => $senderName,
	"CONTACTUS_SENDERMAIL" => htmlspecialchars($email),
	"CONTACTUS_MESSAGE" => htmlspecialchars($message),
));

?>